/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.wpdf;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.wpdf.WPDFStructuredResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WPDFResponseParser
extends BaseProcessor {
    private static final Pattern P_PSGR_TYPE = Pattern.compile("^PSGR TYPE[ ]+([A-Z0-9]{3})[ ]*$", 8);
    private static final Pattern P_FINAL_DOT = Pattern.compile("^\\.[ ]*$", 8);
    private static final Pattern P_TAX_AMT = Pattern.compile("^\\-TAX AMT.*$", 8);
    private static final Pattern P_SECTION_START = Pattern.compile("^\\-.*$", 8);
    private static final Pattern P_TAX_DETAIL = Pattern.compile("^[ ]*[0-9\\.]+[ ]+([A-Z0-9\\/]+).*$", 8);
    private static final Pattern P_TAX_BREAKDOWN = Pattern.compile("^[ ]*[0-9\\.]+\\:([A-Z]{3})[ ]+([0-9\\.]+).*$", 8);

    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        List realPassengerTypes = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.WPDF_REAL_PASSENGER_TYPES);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.WPDF_RESPONSE, (Object)this.parseWPDF(response, realPassengerTypes));
    }

    private WPDFStructuredResponse parseWPDF(String wpdfData, List<String> realPassengerTypes) {
        Iterator<String> realPassengerTypesIterator = realPassengerTypes.iterator();
        WPDFStructuredResponse response = new WPDFStructuredResponse();
        int idx = -1;
        Matcher mPsgrType = P_PSGR_TYPE.matcher(wpdfData);
        while (mPsgrType.find()) {
            if (idx != -1) {
                response.getPqs().add(this.parsePQ(wpdfData.substring(idx, mPsgrType.start()), realPassengerTypesIterator.next()));
            }
            idx = mPsgrType.start();
        }
        if (idx == -1) {
            throw Xeption.forDeveloper((String)wpdfData, (Object[])new Object[0]);
        }
        Matcher mFinalDot = P_FINAL_DOT.matcher(wpdfData);
        if (!mFinalDot.find()) {
            throw Xeption.forDeveloper((String)"FINAL_DOT not found", (Object[])new Object[0]);
        }
        response.getPqs().add(this.parsePQ(wpdfData.substring(idx, mFinalDot.start()), realPassengerTypesIterator.next()));
        if (realPassengerTypesIterator.hasNext()) {
            throw Xeption.forDeveloper((String)"realPassengerTypesIterator should have been depleted", (Object[])new Object[0]);
        }
        return response;
    }

    private WPDFStructuredResponse.PQ parsePQ(String pqData, String realPassengerType) {
        WPDFStructuredResponse.PQ pq = new WPDFStructuredResponse.PQ();
        pq.setPassengerTypeCode(realPassengerType);
        Matcher mTaxAmt = P_TAX_AMT.matcher(pqData);
        if (mTaxAmt.find()) {
            Matcher mSectionStart = P_SECTION_START.matcher(pqData);
            if (!mSectionStart.find(mTaxAmt.start() + 1)) {
                throw Xeption.forDeveloper((String)"SECTION_START not found", (Object[])new Object[0]);
            }
            pq.getTaxDetails().addAll(this.parseTaxDetails(pqData.substring(mTaxAmt.start(), mSectionStart.start())));
        }
        return pq;
    }

    private List<WPDFStructuredResponse.PQ.TaxDetails> parseTaxDetails(String taxDetailsData) {
        ArrayList<WPDFStructuredResponse.PQ.TaxDetails> taxDetails = new ArrayList<WPDFStructuredResponse.PQ.TaxDetails>();
        int idx = -1;
        WPDFStructuredResponse.PQ.TaxDetails details = null;
        Matcher mTaxDetail = P_TAX_DETAIL.matcher(taxDetailsData);
        while (mTaxDetail.find()) {
            if (idx != -1) {
                details.getTaxBreakdowns().addAll(this.parseTaxBreakdowns(taxDetailsData.substring(idx, mTaxDetail.start())));
                taxDetails.add(details);
            }
            details = new WPDFStructuredResponse.PQ.TaxDetails();
            details.setCodes(mTaxDetail.group(1));
            idx = mTaxDetail.start();
        }
        if (idx == -1) {
            throw Xeption.forDeveloper((String)"no TAX_DETAIL found", (Object[])new Object[0]);
        }
        details.getTaxBreakdowns().addAll(this.parseTaxBreakdowns(taxDetailsData.substring(idx)));
        taxDetails.add(details);
        return taxDetails;
    }

    private List<WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown> parseTaxBreakdowns(String taxBreakdownsData) {
        ArrayList<WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown> taxBreakdowns = new ArrayList<WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown>();
        Matcher mTaxBreakdown = P_TAX_BREAKDOWN.matcher(taxBreakdownsData);
        while (mTaxBreakdown.find()) {
            WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown taxBreakdown = new WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown();
            taxBreakdown.setBaseCurrencyCode(mTaxBreakdown.group(1));
            taxBreakdown.setBaseAmount(new BigDecimal(mTaxBreakdown.group(2)));
            taxBreakdowns.add(taxBreakdown);
        }
        return taxBreakdowns;
    }
}

