
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Sabre: address for general use. Contains usage information a choice between simple and detailed address structures.
 OTA 1.8: AddressInfoType
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address">
 *   &lt;xs:sequence>
 *     &lt;xs:group ref="ns:_AddressChoiceGroup"/>
 *     &lt;xs:group ref="ns:_AddressChoiceGroup"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:string" name="role"/>
 *   &lt;xs:attribute type="xs:string" name="rph"/>
 *   &lt;xs:attribute type="ns:ShareIndicator" name="shareSync"/>
 *   &lt;xs:attribute type="ns:ShareIndicator" name="shareMarketing"/>
 *   &lt;xs:attribute type="xs:boolean" name="defaultInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Address implements Serializable
{
    private _AddressChoiceGroup addressChoiceGroup;
    private _AddressChoiceGroup addressChoiceGroup1;
    private String type;
    private String role;
    private String rph;
    private ShareIndicator shareSync;
    private ShareIndicator shareMarketing;
    private Boolean defaultInd;

    /** 
     * Get the '_AddressChoiceGroup' group value.
     * 
     * @return value
     */
    public _AddressChoiceGroup getAddressChoiceGroup() {
        return addressChoiceGroup;
    }

    /** 
     * Set the '_AddressChoiceGroup' group value.
     * 
     * @param _AddressChoiceGroup
     */
    public void setAddressChoiceGroup(_AddressChoiceGroup _AddressChoiceGroup) {
        addressChoiceGroup = _AddressChoiceGroup;
    }

    /** 
     * Get the '_AddressChoiceGroup' group value.
     * 
     * @return value
     */
    public _AddressChoiceGroup getAddressChoiceGroup1() {
        return addressChoiceGroup1;
    }

    /** 
     * Set the '_AddressChoiceGroup' group value.
     * 
     * @param _AddressChoiceGroup1
     */
    public void setAddressChoiceGroup1(_AddressChoiceGroup _AddressChoiceGroup1) {
        addressChoiceGroup1 = _AddressChoiceGroup1;
    }

    /** 
     * Get the 'type' attribute value. OTA - Type = OTA_CodeType = Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT).TODO - turn into enumeration and union with string
    Home
    Business
    Other
    Destination

     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. OTA - Type = OTA_CodeType = Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT).TODO - turn into enumeration and union with string
    Home
    Business
    Other
    Destination

     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'role' attribute value. Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OTA Code List Address Use Type (AUT).TODO - convert into enumeration using values From OTA code table 20080611.xls
    Delivery
    Mailing
    Billing
    Credit card
    Other
    Contact
    Physical
    Pre-opening office
    Collection
    Chain
    Deposit
    Hotel

     * 
     * @return value
     */
    public String getRole() {
        return role;
    }

    /** 
     * Set the 'role' attribute value. Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OTA Code List Address Use Type (AUT).TODO - convert into enumeration using values From OTA code table 20080611.xls
    Delivery
    Mailing
    Billing
    Credit card
    Other
    Contact
    Physical
    Pre-opening office
    Collection
    Chain
    Deposit
    Hotel

     * 
     * @param role
     */
    public void setRole(String role) {
        this.role = role;
    }

    /** 
     * Get the 'rph' attribute value. Used elsewhere in the message to reference this specific address.
     * 
     * @return value
     */
    public String getRph() {
        return rph;
    }

    /** 
     * Set the 'rph' attribute value. Used elsewhere in the message to reference this specific address.
     * 
     * @param rph
     */
    public void setRph(String rph) {
        this.rph = rph;
    }

    /** 
     * Get the 'shareSync' attribute value.
     * 
     * @return value
     */
    public ShareIndicator getShareSync() {
        return shareSync;
    }

    /** 
     * Set the 'shareSync' attribute value.
     * 
     * @param shareSync
     */
    public void setShareSync(ShareIndicator shareSync) {
        this.shareSync = shareSync;
    }

    /** 
     * Get the 'shareMarketing' attribute value.
     * 
     * @return value
     */
    public ShareIndicator getShareMarketing() {
        return shareMarketing;
    }

    /** 
     * Set the 'shareMarketing' attribute value.
     * 
     * @param shareMarketing
     */
    public void setShareMarketing(ShareIndicator shareMarketing) {
        this.shareMarketing = shareMarketing;
    }

    /** 
     * Get the 'defaultInd' attribute value. OTA 1.8 - Indicates that the receiving system should assume the default value if the user specifies no overriding value or action.
     * 
     * @return value
     */
    public Boolean getDefaultInd() {
        return defaultInd;
    }

    /** 
     * Set the 'defaultInd' attribute value. OTA 1.8 - Indicates that the receiving system should assume the default value if the user specifies no overriding value or action.
     * 
     * @param defaultInd
     */
    public void setDefaultInd(Boolean defaultInd) {
        this.defaultInd = defaultInd;
    }
}
