
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Sabre - use only when detailed and structured address is required.
 Create customized extensions and add to choice group when host applications have different detailed structure to capture.
 OTA 1.8: AddressType = Provides address information. 
 Sabre - use only when detailed and structured address is required.
 Create customized extensions and add to choice group when host applications have different detailed structure to capture.
 OTA 1.8: AddressType = Provides address information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address.Detailed">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Building" name="Building" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:Street" name="Street" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="County" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateProv" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressDetailed implements Serializable
{
    private List<Building> buildingList = new ArrayList<Building>();
    private Street street;
    private String city;
    private String county;
    private String stateProv;
    private String country;
    private String postalCode;

    /** 
     * Get the list of 'Building' element items. Building name, room, apartment, or suite number.
     * 
     * @return list
     */
    public List<Building> getBuildingList() {
        return buildingList;
    }

    /** 
     * Set the list of 'Building' element items. Building name, room, apartment, or suite number.
     * 
     * @param list
     */
    public void setBuildingList(List<Building> list) {
        buildingList = list;
    }

    /** 
     * Get the 'Street' element value. May contain the street number and street name.
     * 
     * @return value
     */
    public Street getStreet() {
        return street;
    }

    /** 
     * Set the 'Street' element value. May contain the street number and street name.
     * 
     * @param street
     */
    public void setStreet(Street street) {
        this.street = street;
    }

    /** 
     * Get the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'County' element value. County or Region Name (e.g., Fairfax).
     * 
     * @return value
     */
    public String getCounty() {
        return county;
    }

    /** 
     * Set the 'County' element value. County or Region Name (e.g., Fairfax).
     * 
     * @param county
     */
    public void setCounty(String county) {
        this.county = county;
    }

    /** 
     * Get the 'StateProv' element value. State or Province name (e.g., Texas).
     * 
     * @return value
     */
    public String getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State or Province name (e.g., Texas).
     * 
     * @param stateProv
     */
    public void setStateProv(String stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'Country' element value. Country name (e.g., Ireland).
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Country name (e.g., Ireland).
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'PostalCode' element value. Post Office Code number.
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Post Office Code number.
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }
}
