
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Use for most addresses. Contents are semi-formatted, with simple city, state, country and postal code broken out.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address.Simple">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Line" minOccurs="0" maxOccurs="6"/>
 *     &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateProv" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressSimple implements Serializable
{
    private List<String> lineList = new ArrayList<String>();
    private String city;
    private String stateProv;
    private String country;
    private String postalCode;

    /** 
     * Get the list of 'Line' element items. These  lines contain free form address details.
     * 
     * @return list
     */
    public List<String> getLineList() {
        return lineList;
    }

    /** 
     * Set the list of 'Line' element items. These  lines contain free form address details.
     * 
     * @param list
     */
    public void setLineList(List<String> list) {
        lineList = list;
    }

    /** 
     * Get the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'StateProv' element value. State or Province name (e.g., Texas).
     * 
     * @return value
     */
    public String getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State or Province name (e.g., Texas).
     * 
     * @param stateProv
     */
    public void setStateProv(String stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'Country' element value. Country name (e.g., Ireland).
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Country name (e.g., Ireland).
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'PostalCode' element value. Post Office Code number.
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Post Office Code number.
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }
}
