
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Domestic airport taxes collected from and paid by the customer
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirportTax">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute name="taxCode">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class TaxCode -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:string" use="required" name="airportCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirportTax implements Serializable
{
    private Amount amount;
    private TaxCode taxCode;
    private String airportCode;

    /** 
     * Get the 'Amount' element value.
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value.
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'taxCode' attribute value. A code that applies to the tax (e.g, US, ZP)
     * 
     * @return value
     */
    public TaxCode getTaxCode() {
        return taxCode;
    }

    /** 
     * Set the 'taxCode' attribute value. A code that applies to the tax (e.g, US, ZP)
     * 
     * @param taxCode
     */
    public void setTaxCode(TaxCode taxCode) {
        this.taxCode = taxCode;
    }

    /** 
     * Get the 'airportCode' attribute value. A city code associated to ZP and XF taxes
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'airportCode' attribute value. A city code associated to ZP and XF taxes
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="XF"/>
     *     &lt;xs:enumeration value="ZP"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum TaxCode implements Serializable {
        XF, ZP
    }
}
