
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinOrFareType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cabin"/>
 *     &lt;xs:enumeration value="Fare"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CabinOrFareType implements Serializable {
    CABIN("Cabin"), FARE("Fare");
    private final String value;

    private CabinOrFareType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CabinOrFareType convert(String value) {
        for (CabinOrFareType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
