
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Calculate.MiscTransInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyCodeList" name="InputCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ExemptGSTTax" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ExemptPSTTax" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CalculateMiscTransInfo implements Serializable
{
    private CurrencyCodeList inputCurrency;
    private Boolean exemptGSTTax;
    private Boolean exemptPSTTax;

    /** 
     * Get the 'InputCurrency' element value. Currency code inputted by the agent and used to calculate fees.  Mapped to:  SR05_11_ICUR
     * 
     * @return value
     */
    public CurrencyCodeList getInputCurrency() {
        return inputCurrency;
    }

    /** 
     * Set the 'InputCurrency' element value. Currency code inputted by the agent and used to calculate fees.  Mapped to:  SR05_11_ICUR
     * 
     * @param inputCurrency
     */
    public void setInputCurrency(CurrencyCodeList inputCurrency) {
        this.inputCurrency = inputCurrency;
    }

    /** 
     * Get the 'ExemptGSTTax' element value. An indicator to exempt government sales tax (GST) in Canada.  Mapped to: SR05_11_TEXP,#SR05_11_GSTP
     * 
     * @return value
     */
    public Boolean getExemptGSTTax() {
        return exemptGSTTax;
    }

    /** 
     * Set the 'ExemptGSTTax' element value. An indicator to exempt government sales tax (GST) in Canada.  Mapped to: SR05_11_TEXP,#SR05_11_GSTP
     * 
     * @param exemptGSTTax
     */
    public void setExemptGSTTax(Boolean exemptGSTTax) {
        this.exemptGSTTax = exemptGSTTax;
    }

    /** 
     * Get the 'ExemptPSTTax' element value. An indicator to exempt provincial sales tax (GST) in Canada.  Mapped to: SR05_11_TEXP,#SR05_11_PSTP
     * 
     * @return value
     */
    public Boolean getExemptPSTTax() {
        return exemptPSTTax;
    }

    /** 
     * Set the 'ExemptPSTTax' element value. An indicator to exempt provincial sales tax (GST) in Canada.  Mapped to: SR05_11_TEXP,#SR05_11_PSTP
     * 
     * @param exemptPSTTax
     */
    public void setExemptPSTTax(Boolean exemptPSTTax) {
        this.exemptPSTTax = exemptPSTTax;
    }
}
