
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CompletionCodes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="Incomplete"/>
 *     &lt;xs:enumeration value="NotProcessed"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CompletionCodes implements Serializable {
    COMPLETE("Complete"), INCOMPLETE("Incomplete"), NOT_PROCESSED(
            "NotProcessed"), UNKNOWN("Unknown");
    private final String value;

    private CompletionCodes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CompletionCodes convert(String value) {
        for (CompletionCodes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
