
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerDetails.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FrequentFlyer.Misc" name="FrequentFlyer" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:decimal" name="nameRefNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="nameId"/>
 *   &lt;xs:attribute type="xs:string" name="pnrLocator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerDetailsMisc implements Serializable
{
    private FrequentFlyerMisc frequentFlyer;
    private BigDecimal nameRefNumber;
    private BigInteger nameId;
    private String pnrLocator;

    /** 
     * Get the 'FrequentFlyer' element value.
     * 
     * @return value
     */
    public FrequentFlyerMisc getFrequentFlyer() {
        return frequentFlyer;
    }

    /** 
     * Set the 'FrequentFlyer' element value.
     * 
     * @param frequentFlyer
     */
    public void setFrequentFlyer(FrequentFlyerMisc frequentFlyer) {
        this.frequentFlyer = frequentFlyer;
    }

    /** 
     * Get the 'nameRefNumber' attribute value. A name number associated to the traveller or purchaser in the PNR (e.g. 1.1)
     * 
     * @return value
     */
    public BigDecimal getNameRefNumber() {
        return nameRefNumber;
    }

    /** 
     * Set the 'nameRefNumber' attribute value. A name number associated to the traveller or purchaser in the PNR (e.g. 1.1)
     * 
     * @param nameRefNumber
     */
    public void setNameRefNumber(BigDecimal nameRefNumber) {
        this.nameRefNumber = nameRefNumber;
    }

    /** 
     * Get the 'nameId' attribute value. A unique id that is associated to a passenger name in the PNR. Mapped to:  SR05_31_NID
     * 
     * @return value
     */
    public BigInteger getNameId() {
        return nameId;
    }

    /** 
     * Set the 'nameId' attribute value. A unique id that is associated to a passenger name in the PNR. Mapped to:  SR05_31_NID
     * 
     * @param nameId
     */
    public void setNameId(BigInteger nameId) {
        this.nameId = nameId;
    }

    /** 
     * Get the 'pnrLocator' attribute value. A code associated to the reservations of the customer purchasing an ancillary service.  Mapped to: SR05_31_PNR
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'pnrLocator' attribute value. A code associated to the reservations of the customer purchasing an ancillary service.  Mapped to: SR05_31_PNR
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }
}
