
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CustomerDetails.Misc" name="CustomerDetails" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="lastName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="firstName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerMisc implements Serializable
{
    private CustomerDetailsMisc customerDetails;
    private String lastName;
    private String firstName;

    /** 
     * Get the 'CustomerDetails' element value.
     * 
     * @return value
     */
    public CustomerDetailsMisc getCustomerDetails() {
        return customerDetails;
    }

    /** 
     * Set the 'CustomerDetails' element value.
     * 
     * @param customerDetails
     */
    public void setCustomerDetails(CustomerDetailsMisc customerDetails) {
        this.customerDetails = customerDetails;
    }

    /** 
     * Get the 'lastName' attribute value. The last name of the customer who purchased a ticket or service.  Mapped to: SR05_32_LNAM
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'lastName' attribute value. The last name of the customer who purchased a ticket or service.  Mapped to: SR05_32_LNAM
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'firstName' attribute value. The first name of the customer who purchased the ticket or service.  Mapped to: SR05_32_FNAM
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'firstName' attribute value. The first name of the customer who purchased the ticket or service.  Mapped to: SR05_32_FNAM
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
}
