
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiagnosticLevels">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Mock"/>
 *     &lt;xs:enumeration value="Simulate"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DiagnosticLevels implements Serializable {
    /** 
     * Return a sample message without invoking service logic.
     */
    MOCK("Mock"), /** 
                   * Compute response without making changes to service data, state or status. Test Mock access to de
                   */
    SIMULATE("Simulate");
    private final String value;

    private DiagnosticLevels(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DiagnosticLevels convert(String value) {
        for (DiagnosticLevels inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
