
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ErrorStatus.Misc">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="TransportError"/>
 *     &lt;xs:enumeration value="InterfaceError"/>
 *     &lt;xs:enumeration value="ApplicationError"/>
 *     &lt;xs:enumeration value="BusinessLogicError"/>
 *     &lt;xs:enumeration value="Success"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ErrorStatusMisc implements Serializable {
    TRANSPORT_ERROR("TransportError"), INTERFACE_ERROR("InterfaceError"), APPLICATION_ERROR(
            "ApplicationError"), BUSINESS_LOGIC_ERROR("BusinessLogicError"), SUCCESS(
            "Success");
    private final String value;

    private ErrorStatusMisc(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ErrorStatusMisc convert(String value) {
        for (ErrorStatusMisc inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
