
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareStatusType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="constructed"/>
 *     &lt;xs:enumeration value="published"/>
 *     &lt;xs:enumeration value="created"/>
 *     &lt;xs:enumeration value="fareByRule"/>
 *     &lt;xs:enumeration value="fareByRulePrivate"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FareStatusType implements Serializable {
    CONSTRUCTED("constructed"), PUBLISHED("published"), CREATED("created"), /** 
                                                                             * Specifies that the fare was built based on rules.
                                                                             */
    FARE_BY_RULE("fareByRule"), /** 
                                 * The private fare was built by rules.
                                 */
    FARE_BY_RULE_PRIVATE("fareByRulePrivate");
    private final String value;

    private FareStatusType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FareStatusType convert(String value) {
        for (FareStatusType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
