
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeDetails.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Base" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Equiv" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Total" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="EffectiveDate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="description"/>
 *   &lt;xs:attribute type="xs:int" name="quantity"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeeDetailsMisc implements Serializable
{
    private Amount base;
    private Amount equiv;
    private Amount totalTax;
    private Amount total;
    private Date effectiveDate;
    private String code;
    private String description;
    private Integer quantity;

    /** 
     * Get the 'Base' element value. The base fee amount associated to the item or service which does not include taxes.   Mapped to: SR05_C1_BAMT
     * 
     * @return value
     */
    public Amount getBase() {
        return base;
    }

    /** 
     * Set the 'Base' element value. The base fee amount associated to the item or service which does not include taxes.   Mapped to: SR05_C1_BAMT
     * 
     * @param base
     */
    public void setBase(Amount base) {
        this.base = base;
    }

    /** 
     * Get the 'Equiv' element value. The equivalent or converted fee amount associated to the item or service which does not include taxes.   Mapped to: SR05_C1_BAMT
     * 
     * @return value
     */
    public Amount getEquiv() {
        return equiv;
    }

    /** 
     * Set the 'Equiv' element value. The equivalent or converted fee amount associated to the item or service which does not include taxes.   Mapped to: SR05_C1_BAMT
     * 
     * @param equiv
     */
    public void setEquiv(Amount equiv) {
        this.equiv = equiv;
    }

    /** 
     * Get the 'TotalTax' element value. The total fee taxes associated to the item or service purchased.   Mapped to: SR05_C1_TAMT
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. The total fee taxes associated to the item or service purchased.   Mapped to: SR05_C1_TAMT
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'Total' element value. The total fee amount associated to the service including taxes.   Mapped to: SR05_C1_FAMT
     * 
     * @return value
     */
    public Amount getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. The total fee amount associated to the service including taxes.   Mapped to: SR05_C1_FAMT
     * 
     * @param total
     */
    public void setTotal(Amount total) {
        this.total = total;
    }

    /** 
     * Get the 'EffectiveDate' element value. The date the fee and amounts will be effective or can be used for purchase.  Mapped to:  SR05_C1_EFFD
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. The date the fee and amounts will be effective or can be used for purchase.  Mapped to:  SR05_C1_EFFD
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'code' attribute value. PRAS code associated to the  service or item.  Mapped to: SR05_C1_PRAS
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. PRAS code associated to the  service or item.  Mapped to: SR05_C1_PRAS
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'description' attribute value. Description of the purchased item or service.  Mapped to: SR05_C1_DESC
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'description' attribute value. Description of the purchased item or service.  Mapped to: SR05_C1_DESC
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'quantity' attribute value. The number of items purchased per PRAS code.  Mapped to: SR05_C1_IQTY
     * 
     * @return value
     */
    public Integer getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' attribute value. The number of items purchased per PRAS code.  Mapped to: SR05_C1_IQTY
     * 
     * @param quantity
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}
