
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Associating Fees
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees.Association">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:Fees.Linked" name="Linked"/>
 *     &lt;xs:element type="ns:Fees.Grouped" name="Grouped"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class FeesAssociation implements Serializable
{
    private int choiceSelect = -1;
    private static final int LINKED_CHOICE = 0;
    private static final int GROUPED_CHOICE = 1;
    private FeesLinked linked;
    private FeesGrouped grouped;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Linked is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLinked() {
        return choiceSelect == LINKED_CHOICE;
    }

    /** 
     * Get the 'Linked' element value.
     * 
     * @return value
     */
    public FeesLinked getLinked() {
        return linked;
    }

    /** 
     * Set the 'Linked' element value.
     * 
     * @param linked
     */
    public void setLinked(FeesLinked linked) {
        setChoiceSelect(LINKED_CHOICE);
        this.linked = linked;
    }

    /** 
     * Check if Grouped is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGrouped() {
        return choiceSelect == GROUPED_CHOICE;
    }

    /** 
     * Get the 'Grouped' element value.
     * 
     * @return value
     */
    public FeesGrouped getGrouped() {
        return grouped;
    }

    /** 
     * Set the 'Grouped' element value.
     * 
     * @param grouped
     */
    public void setGrouped(FeesGrouped grouped) {
        setChoiceSelect(GROUPED_CHOICE);
        this.grouped = grouped;
    }
}
