
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Scheduled departure airport should be the same as the airport contained in Flight Leg identifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightAirports">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ScheduledDeparture">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="LatestDeparture" minOccurs="0">
 *       &lt;!-- Reference to inner class LatestDeparture -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="DepartureINDOIndicator">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns:INDO">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="ScheduledArrival">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="LatestArrival" minOccurs="0">
 *       &lt;!-- Reference to inner class LatestArrival -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ArrivalINDOIndicator">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns:INDO">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightAirports implements Serializable
{
    private String scheduledDepartureString;
    private Boolean scheduledDepartureIsChanged;
    private LatestDeparture latestDeparture;
    private INDO departureINDOIndicatorINDO;
    private Boolean departureINDOIndicatorIsChanged;
    private String scheduledArrivalString;
    private Boolean scheduledArrivalIsChanged;
    private LatestArrival latestArrival;
    private INDO arrivalINDOIndicatorINDO;
    private Boolean arrivalINDOIndicatorIsChanged;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getScheduledDepartureString() {
        return scheduledDepartureString;
    }

    /** 
     * Set the extension value.
     * 
     * @param scheduledDepartureString
     */
    public void setScheduledDepartureString(String scheduledDepartureString) {
        this.scheduledDepartureString = scheduledDepartureString;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getScheduledDepartureIsChanged() {
        return scheduledDepartureIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param scheduledDepartureIsChanged
     */
    public void setScheduledDepartureIsChanged(
            Boolean scheduledDepartureIsChanged) {
        this.scheduledDepartureIsChanged = scheduledDepartureIsChanged;
    }

    /** 
     * Get the 'LatestDeparture' element value.
     * 
     * @return value
     */
    public LatestDeparture getLatestDeparture() {
        return latestDeparture;
    }

    /** 
     * Set the 'LatestDeparture' element value.
     * 
     * @param latestDeparture
     */
    public void setLatestDeparture(LatestDeparture latestDeparture) {
        this.latestDeparture = latestDeparture;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public INDO getDepartureINDOIndicatorINDO() {
        return departureINDOIndicatorINDO;
    }

    /** 
     * Set the extension value.
     * 
     * @param departureINDOIndicatorINDO
     */
    public void setDepartureINDOIndicatorINDO(INDO departureINDOIndicatorINDO) {
        this.departureINDOIndicatorINDO = departureINDOIndicatorINDO;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getDepartureINDOIndicatorIsChanged() {
        return departureINDOIndicatorIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param departureINDOIndicatorIsChanged
     */
    public void setDepartureINDOIndicatorIsChanged(
            Boolean departureINDOIndicatorIsChanged) {
        this.departureINDOIndicatorIsChanged = departureINDOIndicatorIsChanged;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getScheduledArrivalString() {
        return scheduledArrivalString;
    }

    /** 
     * Set the extension value.
     * 
     * @param scheduledArrivalString
     */
    public void setScheduledArrivalString(String scheduledArrivalString) {
        this.scheduledArrivalString = scheduledArrivalString;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getScheduledArrivalIsChanged() {
        return scheduledArrivalIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param scheduledArrivalIsChanged
     */
    public void setScheduledArrivalIsChanged(Boolean scheduledArrivalIsChanged) {
        this.scheduledArrivalIsChanged = scheduledArrivalIsChanged;
    }

    /** 
     * Get the 'LatestArrival' element value.
     * 
     * @return value
     */
    public LatestArrival getLatestArrival() {
        return latestArrival;
    }

    /** 
     * Set the 'LatestArrival' element value.
     * 
     * @param latestArrival
     */
    public void setLatestArrival(LatestArrival latestArrival) {
        this.latestArrival = latestArrival;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public INDO getArrivalINDOIndicatorINDO() {
        return arrivalINDOIndicatorINDO;
    }

    /** 
     * Set the extension value.
     * 
     * @param arrivalINDOIndicatorINDO
     */
    public void setArrivalINDOIndicatorINDO(INDO arrivalINDOIndicatorINDO) {
        this.arrivalINDOIndicatorINDO = arrivalINDOIndicatorINDO;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getArrivalINDOIndicatorIsChanged() {
        return arrivalINDOIndicatorIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param arrivalINDOIndicatorIsChanged
     */
    public void setArrivalINDOIndicatorIsChanged(
            Boolean arrivalINDOIndicatorIsChanged) {
        this.arrivalINDOIndicatorIsChanged = arrivalINDOIndicatorIsChanged;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LatestDeparture" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LatestDeparture implements Serializable
    {
        private String string;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LatestArrival" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LatestArrival implements Serializable
    {
        private String string;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
}
