
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightLeg.OPS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Flight.Identifier.withSuffix" name="FlightId"/>
 *     &lt;xs:element type="ns:Flight.Identifier.withSuffix" name="ReplacementFlightId" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightLeg.Identifier" name="FlightLegId"/>
 *     &lt;xs:element type="ns:FlightLeg.Identifier" name="ReplacementFlightLegId" minOccurs="0"/>
 *     &lt;xs:element name="FlightLegReferenceNumber" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightLegReferenceNumber -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ServiceType">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="VersionNumber">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:int">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:EquipmentInformation" name="Equipment"/>
 *     &lt;xs:element type="ns:FlightAirports" name="Airports"/>
 *     &lt;xs:element type="ns:FlightTimes" name="Time"/>
 *     &lt;xs:element type="ns:DelayInformation" name="Delay" minOccurs="0"/>
 *     &lt;xs:element name="Status">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns:LegStatus">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpecialStatus" minOccurs="0">
 *       &lt;!-- Reference to inner class SpecialStatus -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:GateInformation" name="Gate" minOccurs="0"/>
 *     &lt;xs:element name="ChangeReasons" minOccurs="0">
 *       &lt;!-- Reference to inner class ChangeReasons -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CancelReasonCode" minOccurs="0">
 *       &lt;!-- Reference to inner class CancelReasonCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:Remarks" name="Remarks" minOccurs="0"/>
 *     &lt;xs:element type="ns:Flight.Identifier.withSuffix" name="OnwardFlight" minOccurs="0"/>
 *     &lt;xs:element type="ns:PassengerCounts" name="PassengerCounts" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightLegOPS implements Serializable
{
    private FlightIdentifierWithSuffix flightId;
    private FlightIdentifierWithSuffix replacementFlightId;
    private FlightLegIdentifier flightLegId;
    private FlightLegIdentifier replacementFlightLegId;
    private FlightLegReferenceNumber flightLegReferenceNumber;
    private String serviceTypeString;
    private Boolean serviceTypeIsChanged;
    private int versionNumberInt;
    private Boolean versionNumberIsChanged;
    private EquipmentInformation equipment;
    private FlightAirports airports;
    private FlightTimes time;
    private DelayInformation delay;
    private LegStatus statusLegStatus;
    private Boolean statusIsChanged;
    private SpecialStatus specialStatus;
    private GateInformation gate;
    private ChangeReasons changeReasons;
    private CancelReasonCode cancelReasonCode;
    private Remarks remarks;
    private FlightIdentifierWithSuffix onwardFlight;
    private PassengerCounts passengerCounts;

    /** 
     * Get the 'FlightId' element value.
     * 
     * @return value
     */
    public FlightIdentifierWithSuffix getFlightId() {
        return flightId;
    }

    /** 
     * Set the 'FlightId' element value.
     * 
     * @param flightId
     */
    public void setFlightId(FlightIdentifierWithSuffix flightId) {
        this.flightId = flightId;
    }

    /** 
     * Get the 'ReplacementFlightId' element value. Existance of this ID indicates that the flight identifier has changed.
     * 
     * @return value
     */
    public FlightIdentifierWithSuffix getReplacementFlightId() {
        return replacementFlightId;
    }

    /** 
     * Set the 'ReplacementFlightId' element value. Existance of this ID indicates that the flight identifier has changed.
     * 
     * @param replacementFlightId
     */
    public void setReplacementFlightId(
            FlightIdentifierWithSuffix replacementFlightId) {
        this.replacementFlightId = replacementFlightId;
    }

    /** 
     * Get the 'FlightLegId' element value.
     * 
     * @return value
     */
    public FlightLegIdentifier getFlightLegId() {
        return flightLegId;
    }

    /** 
     * Set the 'FlightLegId' element value.
     * 
     * @param flightLegId
     */
    public void setFlightLegId(FlightLegIdentifier flightLegId) {
        this.flightLegId = flightLegId;
    }

    /** 
     * Get the 'ReplacementFlightLegId' element value. Existance of this ID indicates that the flight leg identifier has changed.
     * 
     * @return value
     */
    public FlightLegIdentifier getReplacementFlightLegId() {
        return replacementFlightLegId;
    }

    /** 
     * Set the 'ReplacementFlightLegId' element value. Existance of this ID indicates that the flight leg identifier has changed.
     * 
     * @param replacementFlightLegId
     */
    public void setReplacementFlightLegId(
            FlightLegIdentifier replacementFlightLegId) {
        this.replacementFlightLegId = replacementFlightLegId;
    }

    /** 
     * Get the 'FlightLegReferenceNumber' element value.
     * 
     * @return value
     */
    public FlightLegReferenceNumber getFlightLegReferenceNumber() {
        return flightLegReferenceNumber;
    }

    /** 
     * Set the 'FlightLegReferenceNumber' element value.
     * 
     * @param flightLegReferenceNumber
     */
    public void setFlightLegReferenceNumber(
            FlightLegReferenceNumber flightLegReferenceNumber) {
        this.flightLegReferenceNumber = flightLegReferenceNumber;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getServiceTypeString() {
        return serviceTypeString;
    }

    /** 
     * Set the extension value.
     * 
     * @param serviceTypeString
     */
    public void setServiceTypeString(String serviceTypeString) {
        this.serviceTypeString = serviceTypeString;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getServiceTypeIsChanged() {
        return serviceTypeIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param serviceTypeIsChanged
     */
    public void setServiceTypeIsChanged(Boolean serviceTypeIsChanged) {
        this.serviceTypeIsChanged = serviceTypeIsChanged;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public int getVersionNumberInt() {
        return versionNumberInt;
    }

    /** 
     * Set the extension value.
     * 
     * @param versionNumberInt
     */
    public void setVersionNumberInt(int versionNumberInt) {
        this.versionNumberInt = versionNumberInt;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getVersionNumberIsChanged() {
        return versionNumberIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param versionNumberIsChanged
     */
    public void setVersionNumberIsChanged(Boolean versionNumberIsChanged) {
        this.versionNumberIsChanged = versionNumberIsChanged;
    }

    /** 
     * Get the 'Equipment' element value.
     * 
     * @return value
     */
    public EquipmentInformation getEquipment() {
        return equipment;
    }

    /** 
     * Set the 'Equipment' element value.
     * 
     * @param equipment
     */
    public void setEquipment(EquipmentInformation equipment) {
        this.equipment = equipment;
    }

    /** 
     * Get the 'Airports' element value.
     * 
     * @return value
     */
    public FlightAirports getAirports() {
        return airports;
    }

    /** 
     * Set the 'Airports' element value.
     * 
     * @param airports
     */
    public void setAirports(FlightAirports airports) {
        this.airports = airports;
    }

    /** 
     * Get the 'Time' element value.
     * 
     * @return value
     */
    public FlightTimes getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value.
     * 
     * @param time
     */
    public void setTime(FlightTimes time) {
        this.time = time;
    }

    /** 
     * Get the 'Delay' element value.
     * 
     * @return value
     */
    public DelayInformation getDelay() {
        return delay;
    }

    /** 
     * Set the 'Delay' element value.
     * 
     * @param delay
     */
    public void setDelay(DelayInformation delay) {
        this.delay = delay;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public LegStatus getStatusLegStatus() {
        return statusLegStatus;
    }

    /** 
     * Set the extension value.
     * 
     * @param statusLegStatus
     */
    public void setStatusLegStatus(LegStatus statusLegStatus) {
        this.statusLegStatus = statusLegStatus;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getStatusIsChanged() {
        return statusIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param statusIsChanged
     */
    public void setStatusIsChanged(Boolean statusIsChanged) {
        this.statusIsChanged = statusIsChanged;
    }

    /** 
     * Get the 'SpecialStatus' element value.
     * 
     * @return value
     */
    public SpecialStatus getSpecialStatus() {
        return specialStatus;
    }

    /** 
     * Set the 'SpecialStatus' element value.
     * 
     * @param specialStatus
     */
    public void setSpecialStatus(SpecialStatus specialStatus) {
        this.specialStatus = specialStatus;
    }

    /** 
     * Get the 'Gate' element value.
     * 
     * @return value
     */
    public GateInformation getGate() {
        return gate;
    }

    /** 
     * Set the 'Gate' element value.
     * 
     * @param gate
     */
    public void setGate(GateInformation gate) {
        this.gate = gate;
    }

    /** 
     * Get the 'ChangeReasons' element value.
     * 
     * @return value
     */
    public ChangeReasons getChangeReasons() {
        return changeReasons;
    }

    /** 
     * Set the 'ChangeReasons' element value.
     * 
     * @param changeReasons
     */
    public void setChangeReasons(ChangeReasons changeReasons) {
        this.changeReasons = changeReasons;
    }

    /** 
     * Get the 'CancelReasonCode' element value.
     * 
     * @return value
     */
    public CancelReasonCode getCancelReasonCode() {
        return cancelReasonCode;
    }

    /** 
     * Set the 'CancelReasonCode' element value.
     * 
     * @param cancelReasonCode
     */
    public void setCancelReasonCode(CancelReasonCode cancelReasonCode) {
        this.cancelReasonCode = cancelReasonCode;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'OnwardFlight' element value. Changes will be indicated in the elements contained in the identifier.
     * 
     * @return value
     */
    public FlightIdentifierWithSuffix getOnwardFlight() {
        return onwardFlight;
    }

    /** 
     * Set the 'OnwardFlight' element value. Changes will be indicated in the elements contained in the identifier.
     * 
     * @param onwardFlight
     */
    public void setOnwardFlight(FlightIdentifierWithSuffix onwardFlight) {
        this.onwardFlight = onwardFlight;
    }

    /** 
     * Get the 'PassengerCounts' element value.
     * 
     * @return value
     */
    public PassengerCounts getPassengerCounts() {
        return passengerCounts;
    }

    /** 
     * Set the 'PassengerCounts' element value.
     * 
     * @param passengerCounts
     */
    public void setPassengerCounts(PassengerCounts passengerCounts) {
        this.passengerCounts = passengerCounts;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightLegReferenceNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightLegReferenceNumber implements Serializable
    {
        private String string;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialStatus" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns:SpecialLegStatus">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpecialStatus implements Serializable
    {
        private SpecialLegStatus specialLegStatus;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public SpecialLegStatus getSpecialLegStatus() {
            return specialLegStatus;
        }

        /** 
         * Set the extension value.
         * 
         * @param specialLegStatus
         */
        public void setSpecialLegStatus(SpecialLegStatus specialLegStatus) {
            this.specialLegStatus = specialLegStatus;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeReasons" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns:ChangeReasons">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeReasons">
     *   &lt;xs:list itemType="xs:string"/>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static class ChangeReasons implements Serializable
    {
        private java.util.List<String> strings = new java.util.ArrayList<String>();
        private Boolean isChanged;

        /** 
         * Get the list of 'ChangeReasons' simpleType items.
         * 
         * @return list
         */
        public java.util.List<String> getStrings() {
            return strings;
        }

        /** 
         * Set the list of 'ChangeReasons' simpleType items.
         * 
         * @param list
         */
        public void setStrings(java.util.List<String> list) {
            strings = list;
        }

        /** 
         * Serializer for 'ChangeReasons' simpleType list.
         * 
         * @param values
         * @return text
         */
        public static String serializeStrings(java.util.List<String> values) {
            if (values == null) {
                return null;
            } else {
                java.lang.StringBuffer buff = new java.lang.StringBuffer();
                for (java.util.Iterator<String> iter = values.iterator(); iter
                        .hasNext();) {
                    if (buff.length() > 0) {
                        buff.append(' ');
                    }
                    String value = iter.next();
                    buff.append(value);
                }
                return buff.toString();
            }
        }

        /** 
         * Deserializer for 'ChangeReasons' simpleType list.
         * 
         * @param text
         * @return values
         * @throws org.jibx.runtime.JiBXException on conversion error
         */
        public static java.util.List<String> deserializeStrings(String text)
                throws org.jibx.runtime.JiBXException {
            org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                public java.lang.Object deserialize(String text)
                        throws org.jibx.runtime.JiBXException {
                    return text;
                }
            };
            return (java.util.List<String>) org.jibx.runtime.Utility
                    .deserializeList(text, ldser);
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelReasonCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CancelReasonCode implements Serializable
    {
        private String string;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
}
