
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Published Departure Time should be the same as contained in flight leg identifier.
 1.     OriginalTimes, PublishedTimes and ScheduleTimes are the same either when a flight is created in Movement Manager (MM) manually or through parsing SSIM.
 2.     PublishedTimes – Are changes to times resulted because of an ASM from Airflite or Schedule Manager product. A manual Retime operation in MM can also change the published time.
 3.     ScheduleTimes – Usually the same as Published or Original times except for the cases explained in item 1 and 2. MM user can reschedule a flight through the application to change the Schedule times.

 Published Departure Time should be the same as contained in flight leg identifier.
 1.     OriginalTimes, PublishedTimes and ScheduleTimes are the same either when a flight is created in Movement Manager (MM) manually or through parsing SSIM.
 2.     PublishedTimes – Are changes to times resulted because of an ASM from Airflite or Schedule Manager product. A manual Retime operation in MM can also change the published time.
 3.     ScheduleTimes – Usually the same as Published or Original times except for the cases explained in item 1 and 2. MM user can reschedule a flight through the application to change the Schedule times.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightTimes">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FlightTimes.DepartureArrival" name="Original"/>
 *     &lt;xs:element type="ns:FlightTimes.Scheduled" name="Published"/>
 *     &lt;xs:element type="ns:FlightTimes.Scheduled" name="PreviousPublished" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightTimes.Scheduled" name="Scheduled" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightTimes.Operational" name="Estimated" minOccurs="0"/>
 *     &lt;xs:element type="ns:FlightTimes.Operational" name="Actual" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightTimes implements Serializable
{
    private FlightTimesDepartureArrival original;
    private FlightTimesScheduled published;
    private FlightTimesScheduled previousPublished;
    private FlightTimesScheduled scheduled;
    private FlightTimesOperational estimated;
    private FlightTimesOperational actual;

    /** 
     * Get the 'Original' element value.
     * 
     * @return value
     */
    public FlightTimesDepartureArrival getOriginal() {
        return original;
    }

    /** 
     * Set the 'Original' element value.
     * 
     * @param original
     */
    public void setOriginal(FlightTimesDepartureArrival original) {
        this.original = original;
    }

    /** 
     * Get the 'Published' element value.
     * 
     * @return value
     */
    public FlightTimesScheduled getPublished() {
        return published;
    }

    /** 
     * Set the 'Published' element value.
     * 
     * @param published
     */
    public void setPublished(FlightTimesScheduled published) {
        this.published = published;
    }

    /** 
     * Get the 'PreviousPublished' element value.
     * 
     * @return value
     */
    public FlightTimesScheduled getPreviousPublished() {
        return previousPublished;
    }

    /** 
     * Set the 'PreviousPublished' element value.
     * 
     * @param previousPublished
     */
    public void setPreviousPublished(FlightTimesScheduled previousPublished) {
        this.previousPublished = previousPublished;
    }

    /** 
     * Get the 'Scheduled' element value.
     * 
     * @return value
     */
    public FlightTimesScheduled getScheduled() {
        return scheduled;
    }

    /** 
     * Set the 'Scheduled' element value.
     * 
     * @param scheduled
     */
    public void setScheduled(FlightTimesScheduled scheduled) {
        this.scheduled = scheduled;
    }

    /** 
     * Get the 'Estimated' element value.
     * 
     * @return value
     */
    public FlightTimesOperational getEstimated() {
        return estimated;
    }

    /** 
     * Set the 'Estimated' element value.
     * 
     * @param estimated
     */
    public void setEstimated(FlightTimesOperational estimated) {
        this.estimated = estimated;
    }

    /** 
     * Get the 'Actual' element value.
     * 
     * @return value
     */
    public FlightTimesOperational getActual() {
        return actual;
    }

    /** 
     * Set the 'Actual' element value.
     * 
     * @param actual
     */
    public void setActual(FlightTimesOperational actual) {
        this.actual = actual;
    }
}
