
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightTimes.Scheduled">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Departure">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:dateTime">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element nillable="true" name="PassengerDeparture" minOccurs="0">
 *       &lt;!-- Reference to inner class PassengerDeparture -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Arrival">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:dateTime">
 *             &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element nillable="true" name="PassengerArrival" minOccurs="0">
 *       &lt;!-- Reference to inner class PassengerArrival -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightTimesScheduled implements Serializable
{
    private Date departureDateTime;
    private Boolean departureIsChanged;
    private PassengerDeparture passengerDeparture;
    private Date arrivalDateTime;
    private Boolean arrivalIsChanged;
    private PassengerArrival passengerArrival;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public Date getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the extension value.
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(Date departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getDepartureIsChanged() {
        return departureIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param departureIsChanged
     */
    public void setDepartureIsChanged(Boolean departureIsChanged) {
        this.departureIsChanged = departureIsChanged;
    }

    /** 
     * Get the 'PassengerDeparture' element value.
     * 
     * @return value
     */
    public PassengerDeparture getPassengerDeparture() {
        return passengerDeparture;
    }

    /** 
     * Set the 'PassengerDeparture' element value.
     * 
     * @param passengerDeparture
     */
    public void setPassengerDeparture(PassengerDeparture passengerDeparture) {
        this.passengerDeparture = passengerDeparture;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public Date getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the extension value.
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(Date arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'IsChanged' attribute value.
     * 
     * @return value
     */
    public Boolean getArrivalIsChanged() {
        return arrivalIsChanged;
    }

    /** 
     * Set the 'IsChanged' attribute value.
     * 
     * @param arrivalIsChanged
     */
    public void setArrivalIsChanged(Boolean arrivalIsChanged) {
        this.arrivalIsChanged = arrivalIsChanged;
    }

    /** 
     * Get the 'PassengerArrival' element value.
     * 
     * @return value
     */
    public PassengerArrival getPassengerArrival() {
        return passengerArrival;
    }

    /** 
     * Set the 'PassengerArrival' element value.
     * 
     * @param passengerArrival
     */
    public void setPassengerArrival(PassengerArrival passengerArrival) {
        this.passengerArrival = passengerArrival;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" nillable="true" name="PassengerDeparture" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:dateTime">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerDeparture implements Serializable
    {
        private Date dateTime;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public Date getDateTime() {
            return dateTime;
        }

        /** 
         * Set the extension value.
         * 
         * @param dateTime
         */
        public void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" nillable="true" name="PassengerArrival" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:dateTime">
     *         &lt;xs:attribute type="xs:boolean" name="IsChanged"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerArrival implements Serializable
    {
        private Date dateTime;
        private Boolean isChanged;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public Date getDateTime() {
            return dateTime;
        }

        /** 
         * Set the extension value.
         * 
         * @param dateTime
         */
        public void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'IsChanged' attribute value.
         * 
         * @return value
         */
        public Boolean getIsChanged() {
            return isChanged;
        }

        /** 
         * Set the 'IsChanged' attribute value.
         * 
         * @param isChanged
         */
        public void setIsChanged(Boolean isChanged) {
            this.isChanged = isChanged;
        }
    }
}
