
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Unique identifier of the member in the program.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyality">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="Program"/>
 *       &lt;xs:attribute type="xs:string" name="Level"/>
 *       &lt;xs:attribute type="xs:string" name="Partners"/>
 *       &lt;xs:attribute type="xs:string" name="TravelSector"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Loyality implements Serializable
{
    private String string;
    private String program;
    private String level;
    private String partners;
    private String travelSector;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Program' attribute value. Identifier for the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getProgram() {
        return program;
    }

    /** 
     * Set the 'Program' attribute value. Identifier for the company owner of the loyalty program.
     * 
     * @param program
     */
    public void setProgram(String program) {
        this.program = program;
    }

    /** 
     * Get the 'Level' attribute value. The level described by the loyalty program.  The value domain of level is completely under control of the airline or provider; do not make non-provider specfic assumptions about its value range.

     * 
     * @return value
     */
    public String getLevel() {
        return level;
    }

    /** 
     * Set the 'Level' attribute value. The level described by the loyalty program.  The value domain of level is completely under control of the airline or provider; do not make non-provider specfic assumptions about its value range.

     * 
     * @param level
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /** 
     * Get the 'Partners' attribute value. The partner(s)/vendor(s) for which the customer loyalty number is valid.
     * 
     * @return value
     */
    public String getPartners() {
        return partners;
    }

    /** 
     * Set the 'Partners' attribute value. The partner(s)/vendor(s) for which the customer loyalty number is valid.
     * 
     * @param partners
     */
    public void setPartners(String partners) {
        this.partners = partners;
    }

    /** 
     * Get the 'TravelSector' attribute value. Identifies the travel sector.  Refer to IATA PADIS Code List for data element 4025.Used to identify the specific travel sector to which the loyalty program applies. Refer to OTA Codelist Travel Sector (TVS).
     * 
     * @return value
     */
    public String getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'TravelSector' attribute value. Identifies the travel sector.  Refer to IATA PADIS Code List for data element 4025.Used to identify the specific travel sector to which the loyalty program applies. Refer to OTA Codelist Travel Sector (TVS).
     * 
     * @param travelSector
     */
    public void setTravelSector(String travelSector) {
        this.travelSector = travelSector;
    }
}
