
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MembershipLevelTypeCodes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="2L"/>
 *     &lt;xs:enumeration value="3L"/>
 *     &lt;xs:enumeration value="BN"/>
 *     &lt;xs:enumeration value="TI"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MembershipLevelTypeCodes implements Serializable {
    _2_L("2L"), _3_L("3L"), BN("BN"), TI("TI");
    private final String value;

    private MembershipLevelTypeCodes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MembershipLevelTypeCodes convert(String value) {
        for (MembershipLevelTypeCodes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
