
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Override.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="EffectiveDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DiscontinueDate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="reasonCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="reasonDesc"/>
 *   &lt;xs:attribute type="xs:string" name="option"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OverrideMisc implements Serializable
{
    private Date effectiveDate;
    private String discontinueDate;
    private String reasonCode;
    private String reasonDesc;
    private String option;

    /** 
     * Get the 'EffectiveDate' element value. The effectivity date when override code can be used.  Mapped to:  SR05_C0_EFFD
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. The effectivity date when override code can be used.  Mapped to:  SR05_C0_EFFD
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'DiscontinueDate' element value. The discontinue date when the override code can be used.  Mapped to:  SR05_C0_DSCD
     * 
     * @return value
     */
    public String getDiscontinueDate() {
        return discontinueDate;
    }

    /** 
     * Set the 'DiscontinueDate' element value. The discontinue date when the override code can be used.  Mapped to:  SR05_C0_DSCD
     * 
     * @param discontinueDate
     */
    public void setDiscontinueDate(String discontinueDate) {
        this.discontinueDate = discontinueDate;
    }

    /** 
     * Get the 'reasonCode' attribute value. Code associated to the reason why a fee override is applied.  Mapped to: SR05_C0_RCOD
     * 
     * @return value
     */
    public String getReasonCode() {
        return reasonCode;
    }

    /** 
     * Set the 'reasonCode' attribute value. Code associated to the reason why a fee override is applied.  Mapped to: SR05_C0_RCOD
     * 
     * @param reasonCode
     */
    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    /** 
     * Get the 'reasonDesc' attribute value. Text that describes the reason why a fee override is applied.  Mapped to: SR05_C0_DESC
     * 
     * @return value
     */
    public String getReasonDesc() {
        return reasonDesc;
    }

    /** 
     * Set the 'reasonDesc' attribute value. Text that describes the reason why a fee override is applied.  Mapped to: SR05_C0_DESC
     * 
     * @param reasonDesc
     */
    public void setReasonDesc(String reasonDesc) {
        this.reasonDesc = reasonDesc;
    }

    /** 
     * Get the 'option' attribute value. Option indicator associated to the override or reason code.  Values can be Y - remarks, T - ticket.  Mapped to:  SR05_C0_EXLS
     * 
     * @return value
     */
    public String getOption() {
        return option;
    }

    /** 
     * Set the 'option' attribute value. Option indicator associated to the override or reason code.  Values can be Y - remarks, T - ticket.  Mapped to:  SR05_C0_EXLS
     * 
     * @param option
     */
    public void setOption(String option) {
        this.option = option;
    }
}
