
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Locations:
 Psuedo - Agency PCC or Agent AAA 
 Actual – where the transaction is initiated
 Home – assigned to the agent account
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Company" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Pseudo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MultiHost" minOccurs="0"/>
 *     &lt;xs:element type="ns:Location.POS" name="Actual" minOccurs="0"/>
 *     &lt;xs:element type="ns:Location.POS" name="Home" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Sine" minOccurs="0"/>
 *     &lt;xs:element type="ns:DutyCodeList" name="DutyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Lniata" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POS implements Serializable
{
    private String company;
    private String pseudo;
    private String multiHost;
    private LocationPOS actual;
    private LocationPOS home;
    private String sine;
    private DutyCodeList dutyCode;
    private String lniata;

    /** 
     * Get the 'Company' element value. The IATA assigned code for the Agency or Airine 
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' element value. The IATA assigned code for the Agency or Airine 
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'Pseudo' element value. Required for most sources, unless MultiHost code is provided.
     * 
     * @return value
     */
    public String getPseudo() {
        return pseudo;
    }

    /** 
     * Set the 'Pseudo' element value. Required for most sources, unless MultiHost code is provided.
     * 
     * @param pseudo
     */
    public void setPseudo(String pseudo) {
        this.pseudo = pseudo;
    }

    /** 
     * Get the 'MultiHost' element value. Airline partition for multi-host source locations.
     * 
     * @return value
     */
    public String getMultiHost() {
        return multiHost;
    }

    /** 
     * Set the 'MultiHost' element value. Airline partition for multi-host source locations.
     * 
     * @param multiHost
     */
    public void setMultiHost(String multiHost) {
        this.multiHost = multiHost;
    }

    /** 
     * Get the 'Actual' element value.
     * 
     * @return value
     */
    public LocationPOS getActual() {
        return actual;
    }

    /** 
     * Set the 'Actual' element value.
     * 
     * @param actual
     */
    public void setActual(LocationPOS actual) {
        this.actual = actual;
    }

    /** 
     * Get the 'Home' element value.
     * 
     * @return value
     */
    public LocationPOS getHome() {
        return home;
    }

    /** 
     * Set the 'Home' element value.
     * 
     * @param home
     */
    public void setHome(LocationPOS home) {
        this.home = home;
    }

    /** 
     * Get the 'Sine' element value. Identifies the agent or party within the requesting entity.
     * 
     * @return value
     */
    public String getSine() {
        return sine;
    }

    /** 
     * Set the 'Sine' element value. Identifies the agent or party within the requesting entity.
     * 
     * @param sine
     */
    public void setSine(String sine) {
        this.sine = sine;
    }

    /** 
     * Get the 'DutyCode' element value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public DutyCodeList getDutyCode() {
        return dutyCode;
    }

    /** 
     * Set the 'DutyCode' element value. An authority code assigned to a requestor.
     * 
     * @param dutyCode
     */
    public void setDutyCode(DutyCodeList dutyCode) {
        this.dutyCode = dutyCode;
    }

    /** 
     * Get the 'Lniata' element value. LNIATA of the Console the agent signed into. 
     * 
     * @return value
     */
    public String getLniata() {
        return lniata;
    }

    /** 
     * Set the 'Lniata' element value. LNIATA of the Console the agent signed into. 
     * 
     * @param lniata
     */
    public void setLniata(String lniata) {
        this.lniata = lniata;
    }
}
