
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Name value pairs of parameters where the contents are the value associated with the name. Parameters are for deployment and operational flexibility and should not be relied upon in service design. Revisions to the service should migrate parameters into the message payload or message subject and action values.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="Name"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Parameters implements Serializable
{
    private String string;
    private String name;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Name' attribute value.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' attribute value.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
