
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Example: 
 <PersonName xmlns="http://services.sabre.com/STL/v01">
 <NamePrefix>Mr. and Mrs.</NamePrefix>
 <GivenName>Joshua</GivenName>
 <Surname>Smith</Surname>
 </PersonName>

 <PersonName NameType="0" ShareMarketInd="Inherit" ShareSynchInd="Inherit" xmlns="http://services.sabre.com/STL/v01">
 <NamePrefix>Ms</NamePrefix>
 <GivenName>Delilah</GivenName>
 <MiddleName>Ann</MiddleName>
 <Surname>Beaudry</Surname>
 </PersonName>
 Example: 
 <PersonName xmlns="http://services.sabre.com/STL/v01">
 <NamePrefix>Mr. and Mrs.</NamePrefix>
 <GivenName>Joshua</GivenName>
 <Surname>Smith</Surname>
 </PersonName>

 <PersonName NameType="0" ShareMarketInd="Inherit" ShareSynchInd="Inherit" xmlns="http://services.sabre.com/STL/v01">
 <NamePrefix>Ms</NamePrefix>
 <GivenName>Delilah</GivenName>
 <MiddleName>Ann</MiddleName>
 <Surname>Beaudry</Surname>
 </PersonName>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName.Detailed">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PersonName">
 *       &lt;xs:attribute type="xs:string" name="nameString"/>
 *       &lt;xs:attribute type="xs:boolean" name="q"/>
 *       &lt;xs:attribute type="xs:string" name="key"/>
 *       &lt;xs:attribute type="xs:string" name="surNameKey"/>
 *       &lt;xs:attribute type="ns:ShareIndicator" name="shareSync"/>
 *       &lt;xs:attribute type="ns:ShareIndicator" name="shareMarket"/>
 *       &lt;xs:attribute type="xs:string" name="source"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PersonNameDetailed extends PersonName implements Serializable
{
    private String nameString;
    private Boolean Q;
    private String key;
    private String surNameKey;
    private ShareIndicator shareSync;
    private ShareIndicator shareMarket;
    private String source;

    /** 
     * Get the 'nameString' attribute value. Unparsed name as a single string. Providers that maintain names as a single string should use this attribute to provide the most reliable form of name data. Contained name elements should be populated as best able from this name string.
     * 
     * @return value
     */
    public String getNameString() {
        return nameString;
    }

    /** 
     * Set the 'nameString' attribute value. Unparsed name as a single string. Providers that maintain names as a single string should use this attribute to provide the most reliable form of name data. Contained name elements should be populated as best able from this name string.
     * 
     * @param nameString
     */
    public void setNameString(String nameString) {
        this.nameString = nameString;
    }

    /** 
     * Get the 'q' attribute value. Q is the quality indicator for the parsed name data. If true there were parsing warnings or errors detected during the parsing of the nameString into the name tokens stored in the elements of this record.
     * 
     * @return value
     */
    public Boolean getQ() {
        return Q;
    }

    /** 
     * Set the 'q' attribute value. Q is the quality indicator for the parsed name data. If true there were parsing warnings or errors detected during the parsing of the nameString into the name tokens stored in the elements of this record.
     * 
     * @param q
     */
    public void setQ(Boolean q) {
        Q = q;
    }

    /** 
     * Get the 'key' attribute value. Unique key provided by the source system to access this record.
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'key' attribute value. Unique key provided by the source system to access this record.
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'surNameKey' attribute value. unique key provided by the source system for the person  described in this record used to identify and associate persons with the same surname.
     * 
     * @return value
     */
    public String getSurNameKey() {
        return surNameKey;
    }

    /** 
     * Set the 'surNameKey' attribute value. unique key provided by the source system for the person  described in this record used to identify and associate persons with the same surname.
     * 
     * @param surNameKey
     */
    public void setSurNameKey(String surNameKey) {
        this.surNameKey = surNameKey;
    }

    /** 
     * Get the 'shareSync' attribute value.
     * 
     * @return value
     */
    public ShareIndicator getShareSync() {
        return shareSync;
    }

    /** 
     * Set the 'shareSync' attribute value.
     * 
     * @param shareSync
     */
    public void setShareSync(ShareIndicator shareSync) {
        this.shareSync = shareSync;
    }

    /** 
     * Get the 'shareMarket' attribute value.
     * 
     * @return value
     */
    public ShareIndicator getShareMarket() {
        return shareMarket;
    }

    /** 
     * Set the 'shareMarket' attribute value.
     * 
     * @param shareMarket
     */
    public void setShareMarket(ShareIndicator shareMarket) {
        this.shareMarket = shareMarket;
    }

    /** 
     * Get the 'source' attribute value.
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'source' attribute value.
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }
}
