
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonNameType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Former"/>
 *     &lt;xs:enumeration value="Nickname"/>
 *     &lt;xs:enumeration value="Alternate"/>
 *     &lt;xs:enumeration value="Maiden"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PersonNameType implements Serializable {
    FORMER("Former"), NICKNAME("Nickname"), ALTERNATE("Alternate"), MAIDEN(
            "Maiden");
    private final String value;

    private PersonNameType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PersonNameType convert(String value) {
        for (PersonNameType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
