
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferenceLevel">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Only"/>
 *     &lt;xs:enumeration value="Unacceptable"/>
 *     &lt;xs:enumeration value="Preferred"/>
 *     &lt;xs:enumeration value="Required"/>
 *     &lt;xs:enumeration value="NoPreference"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PreferenceLevel implements Serializable {
    /** 
     * Preference level that indicates request is only for a specific criterion.
     */
    ONLY("Only"), /** 
                   * Preference level that indicates request is unnacceptable for a specific criterion.
                   */
    UNACCEPTABLE("Unacceptable"), /** 
                                   * Preference level that indicates request is preferred for a specific criterion.
                                   */
    PREFERRED("Preferred"), /** 
                             * Preference level that indicates request is required for a specific criterion.
                             */
    REQUIRED("Required"), /** 
                           * Preference level that indicates there is no preference.
                           */
    NO_PREFERENCE("NoPreference");
    private final String value;

    private PreferenceLevel(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PreferenceLevel convert(String value) {
        for (PreferenceLevel inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
