
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProblemInformation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Identifier.System" name="Source" minOccurs="0"/>
 *     &lt;xs:element type="ns:Identifier.System" name="System" minOccurs="0"/>
 *     &lt;xs:element type="ns:SystemSpecificResults" name="SystemSpecificResults" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:ErrorType" use="optional" name="type"/>
 *   &lt;xs:attribute type="ns:CompletionCodes" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProblemInformation implements Serializable
{
    private IdentifierSystem source;
    private IdentifierSystem system;
    private List<SystemSpecificResults> systemSpecificResultList = new ArrayList<SystemSpecificResults>();
    private ErrorType type;
    private CompletionCodes status;
    private Date timeStamp;

    /** 
     * Get the 'Source' element value. The system that the error reporting system deemed to be the cause of the problem. If omitted, the reporting system is also the source of the problem. For application errors, the element may identify a system the application is dependent upon that failed to respond. For validation errors this may identify the service consumer.
     * 
     * @return value
     */
    public IdentifierSystem getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. The system that the error reporting system deemed to be the cause of the problem. If omitted, the reporting system is also the source of the problem. For application errors, the element may identify a system the application is dependent upon that failed to respond. For validation errors this may identify the service consumer.
     * 
     * @param source
     */
    public void setSource(IdentifierSystem source) {
        this.source = source;
    }

    /** 
     * Get the 'System' element value. The system that created the results record. If the Source system identifier is omitted, the system identified here both was the cause of the problem and created the result record.
     * 
     * @return value
     */
    public IdentifierSystem getSystem() {
        return system;
    }

    /** 
     * Set the 'System' element value. The system that created the results record. If the Source system identifier is omitted, the system identified here both was the cause of the problem and created the result record.
     * 
     * @param system
     */
    public void setSystem(IdentifierSystem system) {
        this.system = system;
    }

    /** 
     * Get the list of 'SystemSpecificResults' element items.
     * 
     * @return list
     */
    public List<SystemSpecificResults> getSystemSpecificResultList() {
        return systemSpecificResultList;
    }

    /** 
     * Set the list of 'SystemSpecificResults' element items.
     * 
     * @param list
     */
    public void setSystemSpecificResultList(List<SystemSpecificResults> list) {
        systemSpecificResultList = list;
    }

    /** 
     * Get the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @return value
     */
    public ErrorType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @param type
     */
    public void setType(ErrorType type) {
        this.type = type;
    }

    /** 
     * Get the 'status' attribute value. Impact of the error on process completion. 
     * 
     * @return value
     */
    public CompletionCodes getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. Impact of the error on process completion. 
     * 
     * @param status
     */
    public void setStatus(CompletionCodes status) {
        this.status = status;
    }

    /** 
     * Get the 'timeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
