
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Relationships.Personal">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Spouse"/>
 *     &lt;xs:enumeration value="Parent"/>
 *     &lt;xs:enumeration value="Family"/>
 *     &lt;xs:enumeration value="Employer"/>
 *     &lt;xs:enumeration value="TravelCompanion"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RelationshipsPersonal implements Serializable {
    SPOUSE("Spouse"), PARENT("Parent"), FAMILY("Family"), EMPLOYER("Employer"), TRAVEL_COMPANION(
            "TravelCompanion"), OTHER("Other");
    private final String value;

    private RelationshipsPersonal(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RelationshipsPersonal convert(String value) {
        for (RelationshipsPersonal inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
