
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="Type"/>
 *       &lt;xs:attribute type="xs:string" name="Code"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Remark implements Serializable
{
    private String string;
    private String type;
    private String code;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Type' attribute value. Type of special remark used (e.g., itinerary remark, invoice remark). Refer to OTA Code List Special Remark Option Type (SRO).
    Possible Sabre Web Services values for "Remark@RemarkType" are: BasicRemark, AlphaCodedRemark, ClientAddressRemark, DeliveryAddressRemark, InvoiceRemark, ItineraryRemark, GroupNameRemark, HistoricalRemark, HiddenRemark, or CorporateNumberRemark
    OTA Values 1 through 31 meaning: Itinerary, Invoice, Endorsement, Split, Save, Confidential, Free, Group revenue management system (GRMS), General, Address, Document instructions, electronic courier device code, Boarding pass, Pocket itinerary, Destination purpose, Client account, Corporate id, Commission, Electronic certificate, Tour, Passenger email, Travel agency email, Passenger message, Client billing address, Client delivery address, Consolidator, Unique, Group type, Customer type, Travel flexibility, Show up
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Type of special remark used (e.g., itinerary remark, invoice remark). Refer to OTA Code List Special Remark Option Type (SRO).
    Possible Sabre Web Services values for "Remark@RemarkType" are: BasicRemark, AlphaCodedRemark, ClientAddressRemark, DeliveryAddressRemark, InvoiceRemark, ItineraryRemark, GroupNameRemark, HistoricalRemark, HiddenRemark, or CorporateNumberRemark
    OTA Values 1 through 31 meaning: Itinerary, Invoice, Endorsement, Split, Save, Confidential, Free, Group revenue management system (GRMS), General, Address, Document instructions, electronic courier device code, Boarding pass, Pocket itinerary, Destination purpose, Client account, Corporate id, Commission, Electronic certificate, Tour, Passenger email, Travel agency email, Passenger message, Client billing address, Client delivery address, Consolidator, Unique, Group type, Customer type, Travel flexibility, Show up
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Code' attribute value.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }
}
