
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestedDetailLevel">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Full"/>
 *     &lt;xs:enumeration value="Summary"/>
 *     &lt;xs:enumeration value="Acknowledgement"/>
 *     &lt;xs:enumeration value="None"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RequestedDetailLevel implements Serializable {
    FULL("Full"), SUMMARY("Summary"), ACKNOWLEDGEMENT("Acknowledgement"), /** 
                                                                           * Specifies that the fare is for a roundtrip.
                                                                           */
    NONE("None");
    private final String value;

    private RequestedDetailLevel(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RequestedDetailLevel convert(String value) {
        for (RequestedDetailLevel inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
