
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Nov 9, 2010 - dmh - moved attriubtes upto the header components.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResultRecord">
 *   &lt;xs:sequence>
 *     &lt;xs:group ref="ns:SuccessOrErrorCG"/>
 *     &lt;xs:element type="ns:ProblemInformation" name="Warning" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResultRecord implements Serializable
{
    private SuccessOrErrorCG successOrErrorCG;
    private List<ProblemInformation> warningList = new ArrayList<ProblemInformation>();

    /** 
     * Get the 'SuccessOrErrorCG' group value.
     * 
     * @return value
     */
    public SuccessOrErrorCG getSuccessOrErrorCG() {
        return successOrErrorCG;
    }

    /** 
     * Set the 'SuccessOrErrorCG' group value.
     * 
     * @param successOrErrorCG
     */
    public void setSuccessOrErrorCG(SuccessOrErrorCG successOrErrorCG) {
        this.successOrErrorCG = successOrErrorCG;
    }

    /** 
     * Get the list of 'Warning' element items.
     * 
     * @return list
     */
    public List<ProblemInformation> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items.
     * 
     * @param list
     */
    public void setWarningList(List<ProblemInformation> list) {
        warningList = list;
    }
}
