
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Sabre Standard Payload Header for Acknowledgements of notifications or reciept of requests. Information in the header is intended to separate transport and processing information from actual message data. Header information may be replicated in the messaging system header. This data is inteded for use with content-based routing and other tasks asscociated with integration.  NOTE: messaging and transport systems may and should add content to the header whereas they should never change the actual message subject contents.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STL_Header.Ack">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:STL_HeaderBase">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ResultRecord" name="Results"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class STLHeaderAck extends STLHeaderBase implements Serializable
{
    private ResultRecord results;

    /** 
     * Get the 'Results' element value. Response message header Results are used to exchange information about the nature of a failure or success. This record must be provided in successful service invocations. May also contain system specific error, result and diagnostic data.
     * 
     * @return value
     */
    public ResultRecord getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value. Response message header Results are used to exchange information about the nature of a failure or success. This record must be provided in successful service invocations. May also contain system specific error, result and diagnostic data.
     * 
     * @param results
     */
    public void setResults(ResultRecord results) {
        this.results = results;
    }
}
