
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Sabre Standard Payload Header. Information in the header is intended to separate transport and processing information from actual message data. Header information may be replicated in the messaging system header. This data is inteded for use with content-based routing and other tasks asscociated with integration.  NOTE: messaging and transport systems may and should add content to the header whereas they should never change the actual message subject contents.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STL_Header.RQ">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:STL_HeaderBase">
 *       &lt;xs:attribute type="xs:integer" name="ttl"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class STLHeaderRQ extends STLHeaderBase implements Serializable
{
    private BigInteger ttl;

    /** 
     * Get the 'ttl' attribute value. Time-To-Live (TTL) is the number of seconds a system is requested wait after receipt of the message for a response before forcing the transaction to be over.  A TTL fault condition is handled as an error, closing and/or freeing all open resources. This value may override a contract specified value if allowed by the contract and associated SLA.
    Note: gateways and proxies are not expected to manipulate the TTL value. The value used by “inner” or "downsteam" applications should be less than or equal to the TTL value.
     * 
     * @return value
     */
    public BigInteger getTtl() {
        return ttl;
    }

    /** 
     * Set the 'ttl' attribute value. Time-To-Live (TTL) is the number of seconds a system is requested wait after receipt of the message for a response before forcing the transaction to be over.  A TTL fault condition is handled as an error, closing and/or freeing all open resources. This value may override a contract specified value if allowed by the contract and associated SLA.
    Note: gateways and proxies are not expected to manipulate the TTL value. The value used by “inner” or "downsteam" applications should be less than or equal to the TTL value.
     * 
     * @param ttl
     */
    public void setTtl(BigInteger ttl) {
        this.ttl = ttl;
    }
}
