
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * This is a demonstration sample of a service message derived from the STL_Payload.Abstract.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STL_SampleMessage">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:STL_Payload">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:int" name="SampleProperty1" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="SampleProperty2" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class STLSampleMessage extends STLPayload implements Serializable
{
    private Integer sampleProperty1;
    private Integer sampleProperty2;

    /** 
     * Get the 'SampleProperty1' element value.
     * 
     * @return value
     */
    public Integer getSampleProperty1() {
        return sampleProperty1;
    }

    /** 
     * Set the 'SampleProperty1' element value.
     * 
     * @param sampleProperty1
     */
    public void setSampleProperty1(Integer sampleProperty1) {
        this.sampleProperty1 = sampleProperty1;
    }

    /** 
     * Get the 'SampleProperty2' element value.
     * 
     * @return value
     */
    public Integer getSampleProperty2() {
        return sampleProperty2;
    }

    /** 
     * Set the 'SampleProperty2' element value.
     * 
     * @param sampleProperty2
     */
    public void setSampleProperty2(Integer sampleProperty2) {
        this.sampleProperty2 = sampleProperty2;
    }
}
