
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDirection">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Facing"/>
 *     &lt;xs:enumeration value="Back"/>
 *     &lt;xs:enumeration value="Airline"/>
 *     &lt;xs:enumeration value="Lateral"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SeatDirection implements Serializable {
    FACING("Facing"), BACK("Back"), AIRLINE("Airline"), LATERAL("Lateral"), UNKNOWN(
            "Unknown");
    private final String value;

    private SeatDirection(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SeatDirection convert(String value) {
        for (SeatDirection inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
