
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="WCHC"/>
 *     &lt;xs:enumeration value="ELECTRIC WCHC"/>
 *     &lt;xs:enumeration value="WCHC OWN"/>
 *     &lt;xs:enumeration value="UMNR"/>
 *     &lt;xs:enumeration value="STCR"/>
 *     &lt;xs:enumeration value="BLND"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SpecialServiceType implements Serializable {
    WCHC("WCHC"), ELECTRICWCHC("ELECTRIC WCHC"), WCHCOWN("WCHC OWN"), UMNR(
            "UMNR"), STCR("STCR"), BLND("BLND");
    private final String value;

    private SpecialServiceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SpecialServiceType convert(String value) {
        for (SpecialServiceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
