
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Success">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Identifier.System" name="System" minOccurs="0"/>
 *     &lt;xs:element type="ns:Identifier.System" name="Source" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Success implements Serializable
{
    private IdentifierSystem system;
    private IdentifierSystem source;

    /** 
     * Get the 'System' element value. Endpoint address or system name of the system that created the results record. May not identify the specific system. The id attribute is an unique identifier of the specific system that created the results record.
     * 
     * @return value
     */
    public IdentifierSystem getSystem() {
        return system;
    }

    /** 
     * Set the 'System' element value. Endpoint address or system name of the system that created the results record. May not identify the specific system. The id attribute is an unique identifier of the specific system that created the results record.
     * 
     * @param system
     */
    public void setSystem(IdentifierSystem system) {
        this.system = system;
    }

    /** 
     * Get the 'Source' element value. Endpoint address or system name of the system that the error reporting system deemed to be the cause of the failure. For application errors, the element may be omitted or identify a system the application is dependent upon that failed to respond. For validation errors this may be the service consumer.
     * 
     * @return value
     */
    public IdentifierSystem getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. Endpoint address or system name of the system that the error reporting system deemed to be the cause of the failure. For application errors, the element may be omitted or identify a system the application is dependent upon that failed to respond. For validation errors this may be the service consumer.
     * 
     * @param source
     */
    public void setSource(IdentifierSystem source) {
        this.source = source;
    }
}
