
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SystemSpecificResults">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ErrorMessage" name="ErrorMessage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Element" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RecordID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocURL" minOccurs="0"/>
 *     &lt;xs:element type="ns:DiagnosticResults" name="DiagnosticResults" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SystemSpecificResults implements Serializable
{
    private ErrorMessage errorMessage;
    private String shortText;
    private String element;
    private String recordID;
    private String docURL;
    private DiagnosticResults diagnosticResults;
    private Date timeStamp;

    /** 
     * Get the 'ErrorMessage' element value. Application specific Error code and Message. A textual description to provide more information about the specific error  with code attribute as numeric value.
     * 
     * @return value
     */
    public ErrorMessage getErrorMessage() {
        return errorMessage;
    }

    /** 
     * Set the 'ErrorMessage' element value. Application specific Error code and Message. A textual description to provide more information about the specific error  with code attribute as numeric value.
     * 
     * @param errorMessage
     */
    public void setErrorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    /** 
     * Get the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    /** 
     * Get the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * 
     * @return value
     */
    public String getElement() {
        return element;
    }

    /** 
     * Set the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * 
     * @param element
     */
    public void setElement(String element) {
        this.element = element;
    }

    /** 
     * Get the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s) associated with that transaction.
     * 
     * @return value
     */
    public String getRecordID() {
        return recordID;
    }

    /** 
     * Set the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s) associated with that transaction.
     * 
     * @param recordID
     */
    public void setRecordID(String recordID) {
        this.recordID = recordID;
    }

    /** 
     * Get the 'DocURL' element value. If present, this attribute refers to an online description of the error that occurred.
     * 
     * @return value
     */
    public String getDocURL() {
        return docURL;
    }

    /** 
     * Set the 'DocURL' element value. If present, this attribute refers to an online description of the error that occurred.
     * 
     * @param docURL
     */
    public void setDocURL(String docURL) {
        this.docURL = docURL;
    }

    /** 
     * Get the 'DiagnosticResults' element value. For data not defined elsewhere in the results record. Structure of the contents must be defined elsewhere in the target schema namespace.
     * 
     * @return value
     */
    public DiagnosticResults getDiagnosticResults() {
        return diagnosticResults;
    }

    /** 
     * Set the 'DiagnosticResults' element value. For data not defined elsewhere in the results record. Structure of the contents must be defined elsewhere in the target schema namespace.
     * 
     * @param diagnosticResults
     */
    public void setDiagnosticResults(DiagnosticResults diagnosticResults) {
        this.diagnosticResults = diagnosticResults;
    }

    /** 
     * Get the 'timeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
