
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Telephone">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:anySimpleType" name="location"/>
 *       &lt;xs:attribute type="xs:string" name="use"/>
 *       &lt;xs:attribute type="xs:anySimpleType" name="countryCode"/>
 *       &lt;xs:attribute type="xs:anySimpleType" name="extension"/>
 *       &lt;xs:attribute type="xs:anySimpleType" name="remark"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Telephone implements Serializable
{
    private String string;
    private String location;
    private String use;
    private String countryCode;
    private String extension;
    private String remark;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'location' attribute value. List will be based on PPP Codes
    					Refer to OTA Code List Phone Location Type (PLT).
    1	Brand reservations office
    2	Central reservations office
    3	Property reservation Office
    4	Property direct
    5	Sales office
    6	Home
    7	Office
    8	Other
    9	Managing company
     * 
     * @return value
     */
    public String getLocation() {
        return location;
    }

    /** 
     * Set the 'location' attribute value. List will be based on PPP Codes
    					Refer to OTA Code List Phone Location Type (PLT).
    1	Brand reservations office
    2	Central reservations office
    3	Property reservation Office
    4	Property direct
    5	Sales office
    6	Home
    7	Office
    8	Other
    9	Managing company
     * 
     * @param location
     */
    public void setLocation(String location) {
        this.location = location;
    }

    /** 
     * Get the 'use' attribute value. List will be based on PPP Codes

    					Describes the type of telephone number, in the context of its general use (e.g. Home, Business, Emergency Contact, Travel Arranger, Day, Evening). Refer to OTA Code List Phone Use Type (PUT).
    1	Emergency contact
    2	Travel arranger
    3	Daytime contact
    4	Evening contact
    5	Contact
    6	Toll free number
    7	Guest use
    8	Pickup contact
     * 
     * @return value
     */
    public String getUse() {
        return use;
    }

    /** 
     * Set the 'use' attribute value. List will be based on PPP Codes

    					Describes the type of telephone number, in the context of its general use (e.g. Home, Business, Emergency Contact, Travel Arranger, Day, Evening). Refer to OTA Code List Phone Use Type (PUT).
    1	Emergency contact
    2	Travel arranger
    3	Daytime contact
    4	Evening contact
    5	Contact
    6	Toll free number
    7	Guest use
    8	Pickup contact
     * 
     * @param use
     */
    public void setUse(String use) {
        this.use = use;
    }

    /** 
     * Get the 'countryCode' attribute value. Code assigned by telecommunications authorities for international country access identifier.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'countryCode' attribute value. Code assigned by telecommunications authorities for international country access identifier.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'extension' attribute value. Extension to reach a specific party at the phone number.
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'extension' attribute value. Extension to reach a specific party at the phone number.
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'remark' attribute value. A remark associated with the telephone number.
     * 
     * @return value
     */
    public String getRemark() {
        return remark;
    }

    /** 
     * Set the 'remark' attribute value. A remark associated with the telephone number.
     * 
     * @param remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
}
