
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Base type for transaction specific and tracking information. Intended to be extended when used in service schemas.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionInfo implements Serializable
{
    private String ID;

    /** 
     * Get the 'ID' element value. Transaction Identifier created by service consumer.
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' element value. Transaction Identifier created by service consumer.
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }
}
