
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="URL"/>
 *       &lt;xs:attribute type="xs:string" name="Type"/>
 *       &lt;xs:attribute type="xs:string" name="CompanyName"/>
 *       &lt;xs:attribute type="xs:string" name="ID_Context"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UniqueID implements Serializable
{
    private String string;
    private String URL;
    private String type;
    private String companyName;
    private String IDContext;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'URL' attribute value. URL that identifies the location associated with the record identified by the UniqueID.
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' attribute value. URL that identifies the location associated with the record identified by the UniqueID.
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'Type' attribute value. A reference to the type of object defined by the UniqueID element. Refer to OTA Code List Unique ID Type (UIT).
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. A reference to the type of object defined by the UniqueID element. Refer to OTA Code List Unique ID Type (UIT).
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'CompanyName' attribute value. Identifies the company that is associated with the UniqueID.
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' attribute value. Identifies the company that is associated with the UniqueID.
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'ID_Context' attribute value. Used to identify the source of the identifier (e.g., IATA, ABTA).
     * 
     * @return value
     */
    public String getIDContext() {
        return IDContext;
    }

    /** 
     * Set the 'ID_Context' attribute value. Used to identify the source of the identifier (e.g., IATA, ABTA).
     * 
     * @param IDContext
     */
    public void setIDContext(String IDContext) {
        this.IDContext = IDContext;
    }
}
