
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Value codes: High, Excess
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueCode">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="High"/>
 *     &lt;xs:enumeration value="Excess"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ValueCode implements Serializable {
    HIGH("High"), EXCESS("Excess");
    private final String value;

    private ValueCode(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ValueCode convert(String value) {
        for (ValueCode inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
