
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AddressChoiceGroup">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:Address.Simple" name="Address.Simple"/>
 *     &lt;xs:element type="ns:Address.Detailed" name="Address.Detailed"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class _AddressChoiceGroup implements Serializable
{
    private int choiceSelect = -1;
    private static final int ADDRESS_SIMPLE_CHOICE = 0;
    private static final int ADDRESS_DETAILED_CHOICE = 1;
    private AddressSimple addressSimple;
    private AddressDetailed addressDetailed;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AddressSimple is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddressSimple() {
        return choiceSelect == ADDRESS_SIMPLE_CHOICE;
    }

    /** 
     * Get the 'Address.Simple' element value.
     * 
     * @return value
     */
    public AddressSimple getAddressSimple() {
        return addressSimple;
    }

    /** 
     * Set the 'Address.Simple' element value.
     * 
     * @param addressSimple
     */
    public void setAddressSimple(AddressSimple addressSimple) {
        setChoiceSelect(ADDRESS_SIMPLE_CHOICE);
        this.addressSimple = addressSimple;
    }

    /** 
     * Check if AddressDetailed is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddressDetailed() {
        return choiceSelect == ADDRESS_DETAILED_CHOICE;
    }

    /** 
     * Get the 'Address.Detailed' element value.
     * 
     * @return value
     */
    public AddressDetailed getAddressDetailed() {
        return addressDetailed;
    }

    /** 
     * Set the 'Address.Detailed' element value.
     * 
     * @param addressDetailed
     */
    public void setAddressDetailed(AddressDetailed addressDetailed) {
        setChoiceSelect(ADDRESS_DETAILED_CHOICE);
        this.addressDetailed = addressDetailed;
    }
}
