
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * This private type enumerates flight number literals used for ground links and open segments in an itinerary.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_flightNumberLiterals">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OPEN"/>
 *     &lt;xs:enumeration value="ARNK"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum _FlightNumberLiterals implements Serializable {
    /** 
     * Used in lieu of a flight number when a specific flight number is unknown but service is present.
     */
    OPEN, /** 
           * Used in lieu of a flight number when surface transportation is used when there is a break in the continuity of the flight itinerary.
           */
    ARNK
}
