
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.AccountingReportOperation">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="display"/>
 *     &lt;xs:enumeration value="close"/>
 *     &lt;xs:enumeration value="setRemark"/>
 *     &lt;xs:enumeration value="removeRemark"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeAccountingReportOperation implements Serializable {
    /** 
     * Use this operation to retrieve the report.
     */
    DISPLAY("display"), /** 
                         * Use this operation to close an accounting report.
                         */
    CLOSE("close"), /** 
                     * Use this operation to add or modify a remark on the accounting report.
                     */
    SET_REMARK("setRemark"), /** 
                              * Use this operation to remove an existing remark on the accounting report.
                              */
    REMOVE_REMARK("removeRemark");
    private final String value;

    private CodeAccountingReportOperation(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeAccountingReportOperation convert(String value) {
        for (CodeAccountingReportOperation inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
