
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Used for passing diagnostic information as text
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Misc.Diagnostic">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DataText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="DataXML" minOccurs="0">
 *       &lt;!-- Reference to inner class DataXML -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MiscDiagnostic implements Serializable
{
    private String dataText;
    private DataXML dataXML;
    private String type;

    /** 
     * Get the 'DataText' element value.
     * 
     * @return value
     */
    public String getDataText() {
        return dataText;
    }

    /** 
     * Set the 'DataText' element value.
     * 
     * @param dataText
     */
    public void setDataText(String dataText) {
        this.dataText = dataText;
    }

    /** 
     * Get the 'DataXML' element value.
     * 
     * @return value
     */
    public DataXML getDataXML() {
        return dataXML;
    }

    /** 
     * Set the 'DataXML' element value.
     * 
     * @param dataXML
     */
    public void setDataXML(DataXML dataXML) {
        this.dataXML = dataXML;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataXML" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##any"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:anyAttribute processContents="lax" namespace="##any"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataXML implements Serializable
    {
        private List<Element> anyList = new ArrayList<Element>();

        /** 
         * Get the list of 'DataXML' element items.
         * 
         * @return list
         */
        public List<Element> getAnyList() {
            return anyList;
        }

        /** 
         * Set the list of 'DataXML' element items.
         * 
         * @param list
         */
        public void setAnyList(List<Element> list) {
            anyList = list;
        }
    }
}
