
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Agent who has designated a printer and opened a sales report for the date/station specified.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_ALAgent">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IssuingAgentEmployeeNumber"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentEprCity"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentDieSine"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentShiftStatusCode"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="CashCheckTotalAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class CashCheckTotalAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CreditTotalAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class CreditTotalAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _ALAgent implements Serializable
{
    private String issuingAgentEmployeeNumber;
    private String issuingAgentEprCity;
    private String issuingAgentDieSine;
    private String issuingAgentShiftStatusCode;
    private String currencyCode;
    private CashCheckTotalAmount cashCheckTotalAmount;
    private CreditTotalAmount creditTotalAmount;

    /** 
     * Get the 'IssuingAgentEmployeeNumber' element value. Employee number of the agent.
     * 
     * @return value
     */
    public String getIssuingAgentEmployeeNumber() {
        return issuingAgentEmployeeNumber;
    }

    /** 
     * Set the 'IssuingAgentEmployeeNumber' element value. Employee number of the agent.
     * 
     * @param issuingAgentEmployeeNumber
     */
    public void setIssuingAgentEmployeeNumber(String issuingAgentEmployeeNumber) {
        this.issuingAgentEmployeeNumber = issuingAgentEmployeeNumber;
    }

    /** 
     * Get the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @return value
     */
    public String getIssuingAgentEprCity() {
        return issuingAgentEprCity;
    }

    /** 
     * Set the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @param issuingAgentEprCity
     */
    public void setIssuingAgentEprCity(String issuingAgentEprCity) {
        this.issuingAgentEprCity = issuingAgentEprCity;
    }

    /** 
     * Get the 'IssuingAgentDieSine' element value. Die Sine of the agent.
     * 
     * @return value
     */
    public String getIssuingAgentDieSine() {
        return issuingAgentDieSine;
    }

    /** 
     * Set the 'IssuingAgentDieSine' element value. Die Sine of the agent.
     * 
     * @param issuingAgentDieSine
     */
    public void setIssuingAgentDieSine(String issuingAgentDieSine) {
        this.issuingAgentDieSine = issuingAgentDieSine;
    }

    /** 
     * Get the 'IssuingAgentShiftStatusCode' element value. The status of the issuing agent’s report.
     * 
     * @return value
     */
    public String getIssuingAgentShiftStatusCode() {
        return issuingAgentShiftStatusCode;
    }

    /** 
     * Set the 'IssuingAgentShiftStatusCode' element value. The status of the issuing agent’s report.
     * 
     * @param issuingAgentShiftStatusCode
     */
    public void setIssuingAgentShiftStatusCode(
            String issuingAgentShiftStatusCode) {
        this.issuingAgentShiftStatusCode = issuingAgentShiftStatusCode;
    }

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'CashCheckTotalAmount' element value.
     * 
     * @return value
     */
    public CashCheckTotalAmount getCashCheckTotalAmount() {
        return cashCheckTotalAmount;
    }

    /** 
     * Set the 'CashCheckTotalAmount' element value.
     * 
     * @param cashCheckTotalAmount
     */
    public void setCashCheckTotalAmount(
            CashCheckTotalAmount cashCheckTotalAmount) {
        this.cashCheckTotalAmount = cashCheckTotalAmount;
    }

    /** 
     * Get the 'CreditTotalAmount' element value.
     * 
     * @return value
     */
    public CreditTotalAmount getCreditTotalAmount() {
        return creditTotalAmount;
    }

    /** 
     * Set the 'CreditTotalAmount' element value.
     * 
     * @param creditTotalAmount
     */
    public void setCreditTotalAmount(CreditTotalAmount creditTotalAmount) {
        this.creditTotalAmount = creditTotalAmount;
    }
    /** 
     * Total cash/check amount collected by the agent.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CashCheckTotalAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CashCheckTotalAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
    /** 
     * Total credit amount collected by the agent.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditTotalAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CreditTotalAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
}
