
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Header which contains overall details about the station requested.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_ALHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="ReportDate"/>
 *     &lt;xs:element type="xs:string" name="StationName"/>
 *     &lt;xs:element type="xs:string" name="StationStatusCode"/>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _ALHeader implements Serializable
{
    private Date reportDate;
    private String stationName;
    private String stationStatusCode;
    private String stationNumber;

    /** 
     * Get the 'ReportDate' element value. Report contains data from this date.
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Report contains data from this date.
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the 'StationName' element value. Report contains data from this station.
     * 
     * @return value
     */
    public String getStationName() {
        return stationName;
    }

    /** 
     * Set the 'StationName' element value. Report contains data from this station.
     * 
     * @param stationName
     */
    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    /** 
     * Get the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @return value
     */
    public String getStationStatusCode() {
        return stationStatusCode;
    }

    /** 
     * Set the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @param stationStatusCode
     */
    public void setStationStatusCode(String stationStatusCode) {
        this.stationStatusCode = stationStatusCode;
    }

    /** 
     * Get the 'StationNumber' element value. Report contains data from this station.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Report contains data from this station.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }
}
