
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRQ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AccountingRQ">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RQ" name="Header"/>
 *     &lt;xs:element type="ns1:_AccountingSelectionCriteria" name="SelectionCriteria"/>
 *     &lt;xs:element type="ns1:_AccountingAgentTotals" name="AgentTotals" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AccountingRQ implements Serializable
{
    private STLHeaderRQ header;
    private _AccountingSelectionCriteria selectionCriteria;
    private _AccountingAgentTotals agentTotals;
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public STLHeaderRQ getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(STLHeaderRQ header) {
        this.header = header;
    }

    /** 
     * Get the 'SelectionCriteria' element value. Data captured in the Accounting Report based on the criteria selected
     * 
     * @return value
     */
    public _AccountingSelectionCriteria getSelectionCriteria() {
        return selectionCriteria;
    }

    /** 
     * Set the 'SelectionCriteria' element value. Data captured in the Accounting Report based on the criteria selected
     * 
     * @param selectionCriteria
     */
    public void setSelectionCriteria(
            _AccountingSelectionCriteria selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
    }

    /** 
     * Get the 'AgentTotals' element value. Cash and check actuals held by the agent along with an overage/shortage remark if amounts don’t match expected totals. 
     * 
     * @return value
     */
    public _AccountingAgentTotals getAgentTotals() {
        return agentTotals;
    }

    /** 
     * Set the 'AgentTotals' element value. Cash and check actuals held by the agent along with an overage/shortage remark if amounts don’t match expected totals. 
     * 
     * @param agentTotals
     */
    public void setAgentTotals(_AccountingAgentTotals agentTotals) {
        this.agentTotals = agentTotals;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
